#!/bin/sh
set -eu

. $(pwd)/nix_build_vars

(cd pkcs11-helper && autoreconf -vi)

mkdir -p build-pkcs11-helper
(cd build-pkcs11-helper
    CFLAGS="${CFLAGS:-${HARDENING_FLAGS} -O2}" \
    MBEDTLS_LIBS="-lmbedtls -lmbedx509 -lmbedcrypto" \
    MBEDTLS_CFLAGS="-I$(pwd)/../mbedtls/include/" \
    ../pkcs11-helper/configure \
        --disable-openssl --disable-crypto-engine-gnutls \
        --disable-crypto-engine-nss --disable-crypto-engine-openssl \
        --disable-crypto-engine-cryptoapi \
        --enable-static --disable-shared
)
