#!/bin/sh
set -eu

. $(pwd)/nix_build_vars

(cd openvpn && autoreconf -vif)

mkdir -p build-openvpn-nl
(cd build-openvpn-nl
	CFLAGS="${CFLAGS:--g -O2 ${HARDENING_FLAGS}}" \
	MBEDTLS_CFLAGS="-I$(pwd)/../mbedtls/include" \
	MBEDTLS_LIBS="-L$(pwd)/../build-mbedtls/library -lmbedtls -lmbedx509 -lmbedcrypto" \
	PKCS11_HELPER_CFLAGS="-I$(pwd)/../build-pkcs11-helper/include -I$(pwd)/../pkcs11-helper/include" \
	PKCS11_HELPER_LIBS="-L$(pwd)/../build-pkcs11-helper/lib/.libs -lpkcs11-helper" \
	../openvpn/configure --prefix=/usr/ --with-crypto-library=mbedtls \
		--enable-pkcs11 --enable-iproute2 --disable-ofb-cfb \
		--enable-systemd --disable-lzo --disable-lz4 \
		--disable-plugin-down-root --disable-plugin-auth-pam $@
)
