#!/bin/sh
set -eu

. $(pwd)/windows_build_vars

(cd pkcs11-helper && autoreconf -i -v)

mkdir -p build-pkcs11-helper
(cd build-pkcs11-helper
MBEDTLS_LIBS="-lmbedtls -lmbedx509 -lmbedcrypto" \
MBEDTLS_CFLAGS="${HARDENING_FLAGS} -O2 -I$(pwd)/../mbedtls/include/" \
../pkcs11-helper/configure \
	--host=${CHOST} \
	--build=${CBUILD} \
	--disable-openssl \
	--disable-crypto-engine-gnutls \
	--disable-crypto-engine-nss \
	--disable-crypto-engine-openssl \
	--disable-crypto-engine-cryptoapi \
	--enable-static \
	--disable-shared
)
