#!/bin/sh
. "$(pwd)/build-openvpn-nl/version.sh"

if [ "$OPENVPN_PACKAGE_HOST" = "x86_64-w64-mingw32" -o "$OPENVPN_PACKAGE_HOST" = "i686-w64-mingw32" ]
then
    SYSTEMD_FILES=''
else
    SYSTEMD_FILES='build-openvpn-nl/distro/systemd/*.service'
fi

archive_artifacts()
{
    EXTRA_FILES="${1:-}"
    tar -czvf "${OPENVPN_PACKAGE_TARNAME}_${OPENVPN_PACKAGE_VERSION}-${OPENVPN_RELEASE}.tar.gz" \
        build-mbedtls/library/*.a \
        build-openvpn-nl/src/openvpn/openvpn* build-openvpn-nl/version.sh \
        $SYSTEMD_FILES \
        mbedtls/include/* openvpn/AUTHORS openvpn/ChangeLog openvpn/contrib/* \
        openvpn/COPYING openvpn/COPYRIGHT.GPL \
        build-openvpn-nl/doc/openvpn.8 \
        openvpn/INSTALL openvpn/NEWS openvpn/PORTS \
        openvpn/README* openvpn/sample/* \
        ${EXTRA_FILES}
}
